function [hist_matrix Y1_shock_det errors_str]= historical_decomposition_trend(A0,beta,Y1,X1,n,nlags,ttrend,constant)

Traw             = size(Y1,1) + nlags;            % dimension of the data
errors_red       = Y1 - X1*beta;                  % reduced-form errors
errors_str       = (inv(A0) * errors_red')';      % structural errors
Y1_shock_detrend = zeros(Traw-nlags,n,n);         % preallocate for the final series
hist_matrix      = zeros(Traw,n,n) ;              % preallocate for the historical M
errors_str10     = zeros(Traw-nlags,n,n);         % preallocate for structural-red errors

Y1_shock     = zeros(Traw,n,n);  % these are the responses of different variables
Y1_shock_det = zeros(Traw,n);

if constant == 1
    nc = 1;
else
    nc = 0;
end

if ttrend == 1
    nt = 1;
elseif ttrend == 2
    nt = 2;
else
    nt = 0;
end

for i_lags = 1 : nlags
    Y1_shock_det(i_lags,:)   = X1(1,(nlags-(i_lags-1))*n + (nc+nt) - n+1 : (nlags-(i_lags-1))*n+(nc+nt));     % deterministic component
    for i = 1 : n        
        Y1_shock(i_lags,:,i) = X1(1,(nlags-(i_lags-1))*n + (nc+nt) - n+1 : (nlags-(i_lags-1))*n+(nc+nt));     % contribution of shocks    
    end
end

%% defining auxiliary variables to make lag structure general

auxi_det = zeros(1,nlags*n);
for i=1:nlags
    auxi_det(1,1+(i-1)*n:n+(i-1)*n) = Y1_shock_det((nlags+1)-i,:);
end

for i = 1:n
    lala                = zeros(Traw-nlags,n);  % generating the structural errors
    lala(:,i)           = errors_str(:,i);      % --> only on structural error at a time though!!
    errors_str10(:,:,i) = (A0 * lala')';
end

%% constant versus no constant

if constant == 1
    if ttrend == 1;
        tt = 1;     % this is how I add back the time trend
        for i_time = nlags + 1:Traw
            
            for iauxi=1:nlags
                auxi_det(1,1+(iauxi-1)*n:n+(iauxi-1)*n) = Y1_shock_det(i_time-iauxi,:);
            end
            
            Y1_shock_det(i_time,:) = [1 tt auxi_det] ...
                * beta;
            for i_shock = 1:n
                
                for iauxi2=1:nlags
                    auxi_shock(1,1+(iauxi2-1)*n:n+(iauxi2-1)*n) = Y1_shock(i_time-iauxi2,:,i_shock);
                end
                
                Y1_shock(i_time,:,i_shock) =  [1 tt auxi_shock] ...
                    * beta + errors_str10(i_time-nlags,:,i_shock);
                Y1_shock_detrend(i_time,:,i_shock) = Y1_shock(i_time,:,i_shock) - Y1_shock_det(i_time,:) ;
            end
            tt = tt + 1;    % iterate time trend forward
        end
    elseif ttrend == 2;
        tt = 1;     % this is how I add back the time trend
        tt2 = tt^2;
        for i_time = nlags + 1:Traw
            
            for iauxi=1:nlags
                auxi_det(1,1+(iauxi-1)*n:n+(iauxi-1)*n) = Y1_shock_det(i_time-iauxi,:);
            end
            
            Y1_shock_det(i_time,:) = [1 tt tt2 auxi_det] ...
                * beta;
            for i_shock = 1:n
                
                for iauxi2=1:nlags
                    auxi_shock(1,1+(iauxi2-1)*n:n+(iauxi2-1)*n) = Y1_shock(i_time-iauxi2,:,i_shock);
                end
                
                Y1_shock(i_time,:,i_shock) =  [1 tt tt2 auxi_shock] ...
                    * beta + errors_str10(i_time-nlags,:,i_shock);
                Y1_shock_detrend(i_time,:,i_shock) = Y1_shock(i_time,:,i_shock) - Y1_shock_det(i_time,:) ;
            end
            tt = tt + 1;    % iterate time trend forward
            tt2= tt^2  ;    % iterate quadratic time trend forward
        end
    else    % this is without time trend!
        for i_time = nlags + 1 : Traw
            
             for iauxi=1:nlags
                auxi_det(1,1+(iauxi-1)*n:n+(iauxi-1)*n) = Y1_shock_det(i_time-iauxi,:);
            end
            
            Y1_shock_det(i_time,:) = [1 auxi_det] ...
                * beta;
            for i_shock = 1:n
                
                for iauxi2=1:nlags
                    auxi_shock(1,1+(iauxi2-1)*n:n+(iauxi2-1)*n) = Y1_shock(i_time-iauxi2,:,i_shock);
                end
                
                Y1_shock(i_time,:,i_shock) =  [1 auxi_shock] ...
                    * beta + errors_str10(i_time-nlags,:,i_shock);
                Y1_shock_detrend(i_time,:,i_shock) = Y1_shock(i_time,:,i_shock) - Y1_shock_det(i_time,:) ;
            end
        end
    end

else
    if ttrend == 1;
        tt = 1;     % this is how I add back the time trend
        for i_time = nlags + 1:Traw
            Y1_shock_det(i_time,:) = [tt Y1_shock_det(i_time-1,:) Y1_shock_det(i_time-2,:) Y1_shock_det(i_time-3,:)] ...
                * beta;
            for i_shock = 1:n
                Y1_shock(i_time,:,i_shock) =  [tt Y1_shock(i_time-1,:,i_shock) Y1_shock(i_time-2,:,i_shock) Y1_shock(i_time-3,:,i_shock)] ...
                    * beta + errors_str10(i_time-nlags,:,i_shock);
                Y1_shock_detrend(i_time,:,i_shock) = Y1_shock(i_time,:,i_shock) - Y1_shock_det(i_time,:) ;
            end
            tt = tt + 1;    % iterate time trend forward
        end
    elseif ttrend == 2;
        tt = 1;     % this is how I add back the time trend
        tt2 = tt^2;
        for i_time = nlags + 1:Traw
            Y1_shock_det(i_time,:) = [tt tt2 Y1_shock_det(i_time-1,:) Y1_shock_det(i_time-2,:) Y1_shock_det(i_time-3,:)] ...
                * beta;
            for i_shock = 1:n
                Y1_shock(i_time,:,i_shock) =  [tt tt2 Y1_shock(i_time-1,:,i_shock) Y1_shock(i_time-2,:,i_shock) Y1_shock(i_time-3,:,i_shock)] ...
                    * beta + errors_str10(i_time-nlags,:,i_shock);
                Y1_shock_detrend(i_time,:,i_shock) = Y1_shock(i_time,:,i_shock) - Y1_shock_det(i_time,:) ;
            end
            tt = tt + 1;    % iterate time trend forward
            tt2= tt^2  ;    % iterate quadratic time trend forward
        end
    else        % this is without time trend!
        for i_time = nlags + 1:Traw
            Y1_shock_det(i_time,:) = [Y1_shock_det(i_time-1,:) Y1_shock_det(i_time-2,:) Y1_shock_det(i_time-3,:)] ...
                * beta;
            for i_shock = 1:n
                Y1_shock(i_time,:,i_shock) =  [Y1_shock(i_time-1,:,i_shock) Y1_shock(i_time-2,:,i_shock) Y1_shock(i_time-3,:,i_shock)] ...
                    * beta + errors_str10(i_time-nlags,:,i_shock);
                Y1_shock_detrend(i_time,:,i_shock) = Y1_shock(i_time,:,i_shock) - Y1_shock_det(i_time,:) ;
            end
        end
    end
end

hist_matrix=Y1_shock_detrend;


